/******************************************************************************* 
 * Freescale Semiconductor Inc. 
 * (c) Copyright 2010 Freescale Semiconductor, Inc. 
 * ALL RIGHTS RESERVED. 
 ******************************************************************************** 
 Services performed by FREESCALE in this matter are performed AS IS and without  
 any warranty. CUSTOMER retains the final decision relative to the total design  
 and functionality of the end product. FREESCALE neither guarantees nor will be  
 held liable by CUSTOMER for the success of this project. 
 FREESCALE DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING,  
 BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR  
 A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED TO THE PROJECT 
 BY FREESCALE, AND OR NAY PRODUCT RESULTING FROM FREESCALE SERVICES. IN NO EVENT 
 SHALL FREESCALE BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF  
 THIS AGREEMENT. 
 
 CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or  
 actions by anyone on account of any damage, or injury, whether commercial,  
 contractual, or tortuous, rising directly or indirectly as a result of the advise 
 or assistance supplied CUSTOMER in connection with product, services or goods  
 supplied under this Agreement. 
 ******************************************************************************** 
 * File      main.c 
 * Owner     b32543 
 * Version   0.1   
 
 * Date      Oct-19-2011 
 * Classification   Internal Use Only
 * Brief     Brief description of the file 
 ******************************************************************************** 
 * Detailed Description: 
 * 
 ******************************************************************************** 
 Revision History: 
 Version  Date        Author      Description of Changes 
 0.1     2011.10.19   b32543      Create it.
 *******************************************************************************/
#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "mcu.h"
#include "usb_config.h"
#include "usb_cdc.h"
#include "msCANdrv.h"
#include "virtual_com.h"
#include "USB2CAN.h"
#include "stdio.h"

/******************************************************************************* 
 * External objects 
 *******************************************************************************/

/******************************************************************************* 
 * Global variables 
 *******************************************************************************/

/******************************************************************************* 
 * Constants and macros 
 *******************************************************************************/
#define DEBUG_MODE   1
#define DEBUG_TIGGER  PTGD_PTGD1
/******************************************************************************* 
 * Local types 
 *******************************************************************************/

/******************************************************************************* 
 * Local function prototypes 
 *******************************************************************************/
static void DebugInfoPrint(uint_8* pTrig,uint_8 u8ErrStatus);
/******************************************************************************* 
 * Local variables 
 *******************************************************************************/

/******************************************************************************* 
 * Local functions 
 *******************************************************************************/

/******************************************************************************* 
 * Global functions 
 ******************************************************************************/

/******************************************************************************* 
 Function Name : main 
 Engineer  : b32543 
 Date    : 12/12/11 
 Parameters  :void    
 Modifies  : NONE 
 Returns  :  void 
 Notes    :  Main function  
 Issues   : NONE 
 ******************************************************************************/
void main(void)
{
    uint_8 error = 0U,debug_trigger = 0;
    MCU_Init(); /* call Device Initialization */
    /* include your code here */
    __RESET_WATCHDOG();
    /* Initialize the USB interface */
    while (CAN_Init(FAST) != ERR_OK)
    {
        ;
    }
    VCOM_Init();
    USB2CAN_Init();
    for (;;)
    {
        __RESET_WATCHDOG();
        VCOM_Task();
        debug_trigger = USB2CAN_Task();
#if (DEBUG_MODE == 1)
        DebugInfoPrint(&debug_trigger,g_error_status);
#endif
        /* __RESET_WATCHDOG(); By default COP is disabled with device init. When enabling, also reset the watchdog. */
    }
    /* loop forever */
    /* please make sure that you never leave main */
}

/******************************************************************************* 
 Function Name : DebugInfoPrint 
 Engineer  : b32543 
 Date    : 12/12/11 
 Parameters  :void    
 Modifies  : NONE 
 Returns  :  void 
 Notes    : Print debug information  
 Issues   : NONE 
 ******************************************************************************/
static void DebugInfoPrint(uint_8* pTrig, uint_8 u8ErrStatus)
{
    uint_16 i = 0U;
    static uint_8 print_flag = 0U;

#if 0
    if (PTDD_PTDD5 == 0)
    {

        while (PTDD_PTDD5 == 0U)
        {
            __RESET_WATCHDOG();
        }
#endif
    if (*pTrig == TRUE)
    {
        printf(" \n\r/******USB2CAN Rev1.0******/\n");
        switch (u8ErrStatus)
        {
            case ERR_OK:
                printf("\rOperation OK!\n");
                break;
            case TIMEOUT_ERR:
                printf("\rTimeout Error!\n");
                break;
            case RESPONSE_DATA_ERR:
                printf("\rThe Response data Error!\n");
                break;
            case FRAMEING_ERR:
                printf("\rFraming Error!\n");
                break;
            case CMD_WORD_ERR:
                printf("\rCommand Word Error!\n");
                break;
            case CHECKSUM_ERR:
                printf("\rChecksum Error!\n");
                break;
            default:
                printf("\rUndefined Status!\n");
                break;
        }
        *pTrig = FALSE;
    }

}

